/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import java.util.Random;
import javax.annotation.Nonnull;
import net.creeperhost.chickens.block.BlockBreeder;
import net.creeperhost.chickens.capability.SmartInventory;
import net.creeperhost.chickens.containers.ContainerBreeder;
import net.creeperhost.chickens.data.ChickenStats;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.item.ItemSpawnEgg;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBreeder
extends BlockEntity
implements MenuProvider {
    public SmartInventory inventory = new SmartInventory(6){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntityBreeder.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0 && stack.m_150930_((Item)ModItems.CHICKEN_ITEM.get())) {
                return true;
            }
            if (slot == 1 && stack.m_150930_((Item)ModItems.CHICKEN_ITEM.get())) {
                return true;
            }
            return slot == 2 && stack.m_204117_(Tags.Items.SEEDS);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot <= 2) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    public final ContainerData containerData = new SimpleContainerData(1){

        public int m_6413_(int index) {
            if (index == 0) {
                return BlockEntityBreeder.this.progress;
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public void m_8050_(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 1;
        }
    };
    public int progress = 0;

    public BlockEntityBreeder(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.BREEDER_TILE.get(), blockPos, blockState);
    }

    public void tick() {
        boolean canWork;
        boolean bl = canWork = this.inventory.getStackInSlot(0).m_41720_() instanceof ItemChicken && this.inventory.getStackInSlot(1).m_41720_() instanceof ItemChicken && this.inventory.getStackInSlot(2).m_204117_(Tags.Items.SEEDS);
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (canWork) {
            if (this.progress <= 1000) {
                ++this.progress;
            } else {
                ChickensRegistryItem chickensRegistryItem2;
                ChickensRegistryItem chickensRegistryItem1 = ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(this.inventory.getStackInSlot(0)));
                ChickensRegistryItem baby = ChickensRegistry.getRandomChild(chickensRegistryItem1, chickensRegistryItem2 = ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(this.inventory.getStackInSlot(1))));
                if (baby == null) {
                    this.progress = 0;
                    return;
                }
                ItemStack chickenStack = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get());
                ItemChicken.applyEntityIdToItemStack(chickenStack, baby.getRegistryName());
                ChickenStats babyStats = BlockEntityBreeder.increaseStats(chickenStack, this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.f_58857_.f_46441_);
                babyStats.write(chickenStack);
                chickenStack.m_41764_(1);
                ItemStack inserted = this.moveOutput(chickenStack);
                if (inserted.m_41619_()) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11752_, SoundSource.NEUTRAL, 0.5f, 0.8f);
                    this.spawnParticle(this.f_58857_, this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_(), this.f_58857_.f_46441_);
                    this.inventory.getStackInSlot(2).m_41774_(1);
                    this.progress = 0;
                } else {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BlockBreeder.HAS_SEEDS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockBreeder.IS_BREEDING, (Comparable)Boolean.valueOf(true)), 4);
                }
            }
        } else {
            this.progress = 0;
        }
    }

    public ItemStack moveOutput(ItemStack stack) {
        for (int i = 3; i <= 5; ++i) {
            int max;
            int count;
            if (this.inventory.getStackInSlot(i).m_41619_()) {
                this.inventory.setStackInSlot(i, stack);
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.inventory.getStackInSlot(i)) || (count = this.inventory.getStackInSlot(i).m_41613_()) >= (max = 16)) continue;
            int newCount = count + 1;
            stack.m_41764_(newCount);
            this.inventory.setStackInSlot(i, stack);
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public void spawnParticle(Level worldIn, double posX, double posY, double posZ, Random rand) {
        for (int i = 0; i < 16; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = posX + 0.5 + 0.25 * (double)j;
            double d1 = (float)posY + rand.nextFloat();
            double d2 = posZ + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            if (!(worldIn instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)worldIn;
            serverLevel.m_7106_((ParticleOptions)ParticleTypes.f_123750_, d0, d1, d2, d3, d4, d5);
        }
    }

    private static ChickenStats increaseStats(ItemStack baby, ItemStack parent1, ItemStack parent2, Random rand) {
        boolean mutatingStats;
        ChickenStats babyStats = new ChickenStats(baby);
        ChickenStats parent1Stats = new ChickenStats(parent1);
        ChickenStats parent2Stats = new ChickenStats(parent2);
        boolean bl = mutatingStats = BlockEntityBreeder.getChickenFromStack(parent1).getRegistryName() == BlockEntityBreeder.getChickenFromStack(parent2).getRegistryName() && BlockEntityBreeder.getChickenFromStack(baby).getRegistryName() == BlockEntityBreeder.getChickenFromStack(parent1).getRegistryName();
        if (mutatingStats) {
            babyStats.setGrowth(BlockEntityBreeder.calculateNewStat(parent1Stats.getStrength(), parent2Stats.getStrength(), parent1Stats.getGrowth(), parent2Stats.getGrowth(), rand));
            babyStats.setGain(BlockEntityBreeder.calculateNewStat(parent1Stats.getStrength(), parent2Stats.getStrength(), parent1Stats.getGain(), parent2Stats.getGain(), rand));
            babyStats.setStrength(BlockEntityBreeder.calculateNewStat(parent1Stats.getStrength(), parent2Stats.getStrength(), parent1Stats.getStrength(), parent2Stats.getStrength(), rand));
            return babyStats;
        }
        if (BlockEntityBreeder.getChickenFromStack(parent1).getRegistryName() == BlockEntityBreeder.getChickenFromStack(baby).getRegistryName()) {
            BlockEntityBreeder.inheritStats(babyStats, parent1Stats);
            return babyStats;
        }
        if (BlockEntityBreeder.getChickenFromStack(parent2).getRegistryName() == BlockEntityBreeder.getChickenFromStack(baby).getRegistryName()) {
            BlockEntityBreeder.inheritStats(babyStats, parent2Stats);
            return babyStats;
        }
        return new ChickenStats(baby);
    }

    private static void inheritStats(ChickenStats babyStats, ChickenStats parent1Stats) {
        babyStats.setGrowth(parent1Stats.getGrowth());
        babyStats.setGain(parent1Stats.getGain());
        babyStats.setStrength(parent1Stats.getStrength());
    }

    public static ResourceLocation getRegistryName(ItemStack stack) {
        return Registry.f_122827_.m_7981_((Object)stack.m_41720_());
    }

    private static ChickensRegistryItem getChickenFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemChicken) {
            return ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(stack));
        }
        return null;
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, Random rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        if (newStatValue <= 1) {
            return 1;
        }
        if (newStatValue >= 10) {
            return 10;
        }
        return newStatValue;
    }

    public void m_6596_() {
        super.m_6596_();
        this.updateState();
    }

    public void updateState() {
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            state.m_61124_((Property)BlockBreeder.HAS_SEEDS, (Comparable)Boolean.valueOf(true));
            boolean hasSeeds = !this.inventory.getStackInSlot(2).m_41619_();
            boolean isBreeding = !this.inventory.getStackInSlot(0).m_41619_() && !this.inventory.getStackInSlot(1).m_41619_();
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BlockBreeder.HAS_SEEDS, (Comparable)Boolean.valueOf(hasSeeds))).m_61124_((Property)BlockBreeder.IS_BREEDING, (Comparable)Boolean.valueOf(isBreeding)), 4);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128391_(this.inventory.serializeNBT());
        compound.m_128405_("progress", this.progress);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound);
        this.progress = compound.m_128451_("progress");
    }

    @NotNull
    public Component m_5446_() {
        return new TextComponent("chickens.container.breeder");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new ContainerBreeder(id, inventory, this, this.containerData);
    }
}

